
struct OITLinkBufferElement
{
	uint Color;				// Pixel color
	uint DepthAndCoverage;	// Coverage is only used in the MSAA case
	uint Next;				// Offset of next element
};

RWByteAddressBuffer OITStartOffsetBuffer               : register(u1);
RWStructuredBuffer<OITLinkBufferElement> OITLinkBuffer : register(u2);

#define OIT_AVERAGE_FRAGMENTS  10


//--------------------------------------------------------------------------------------
// Helper functions
//--------------------------------------------------------------------------------------
uint PackFloat4IntoUint(float4 vValue)
{
    return ( ((uint)(vValue.x*255)) << 24 ) | ( ((uint)(vValue.y*255)) << 16 ) | ( ((uint)(vValue.z*255)) << 8) | (uint)(vValue.w * 255);
}

float4 UnpackUintIntoFloat4(uint uValue)
{
    return float4( ( (uValue & 0xFF000000)>>24 ) / 255.0, ( (uValue & 0x00FF0000)>>16 ) / 255.0, ( (uValue & 0x0000FF00)>>8 ) / 255.0, ( (uValue & 0x000000FF) ) / 255.0);
}

uint PackDepthIntoUint(float depth)
{
    return (uint)(depth * 0x00FFFFFF) << 8;
}

uint PackDepthAndCoverageIntoUint(float depth, uint coverage)
{
    return ((uint)(depth * 0x00FFFFFF) << 8) | coverage;
}

uint UnpackDepthIntoUint(uint uDepthAndCoverage)
{
    return (uint)(uDepthAndCoverage >> 8);
}

uint UnpackCoverageIntoUint(uint uDepthAndCoverage)
{
    return (uDepthAndCoverage & 0xff );
}

