#include "world.inc"
#include "material.inc"

Texture2D ColorMap : register( t0 );


SamplerState NearestSampler
{
	Filter   = MIN_MAG_MIP_POINT;
	AddressU = Clamp;
	AddressV = Clamp;
};


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
	float4 Pos : POSITION;
	float3 Normal : NORMAL;
	float2 TexCoord : TEXCOORD0;
};

struct PS_INPUT
{
	float4 Pos : SV_Position;
	float2 TexCoord : TEXCOORD0;
};


PS_INPUT VS(VS_INPUT In)
{
	PS_INPUT Out;
	Out.Pos = In.Pos;
	Out.TexCoord = In.TexCoord;
	return Out;
}

float4 PS(PS_INPUT In) : SV_TARGET
{
	float v = ColorMap.Sample(NearestSampler, In.TexCoord).r;
	return float4(v,v,v,v);
}

