#version 330

uniform mat4 WorldView;
uniform int ClipPlaneNum;
uniform vec4 ClipPlane[4];

uniform sampler2D MatcapSampler;

in vec3 VSWorldPos;
in vec4 VSColor;
in vec3 VSNormal;
in vec2 VSTexCoord;

out vec4 OutColor;

vec3 mul(vec3 v, mat3 m) { return m * v; }
float saturate(float v) { return clamp(v, 0, 1); }
vec2 saturate(vec2 v) { return clamp(v, 0, 1); }
vec3 saturate(vec3 v) { return clamp(v, 0, 1); }
vec4 saturate(vec4 v) { return clamp(v, 0, 1); }

// matcap
void main(void)
{
	for(int i=0; i<ClipPlaneNum; i++){
		if(dot(ClipPlane[i].xyz, VSWorldPos) + ClipPlane[i].w < 0)
			discard;
	}
	vec3 Norm = normalize(VSNormal);
	vec2 matcap_uv = saturate(mul(Norm, mat3(WorldView)).xy*vec2(0.498,-0.498) + 0.5);
	vec4 col = vec4(texture(MatcapSampler, matcap_uv).xyz, 1);
	OutColor = col;
}

