#version 330

uniform mat4 WorldViewProj;
uniform vec4 MapTransform;
uniform vec2 MapTranslate;
uniform vec4 BaseColor;
uniform bool EnableVertexColor;

layout(location = 0) in vec3 Pos;
layout(location = 1) in vec3 Normal;
layout(location = 2) in vec2 TexCoord;
layout(location = 3) in vec4 VertCol;
#if MULTIUV >= 1
layout(location = 5) in vec2 TexCoord1;
#endif
#if MULTIUV >= 2
layout(location = 6) in vec2 TexCoord2;
#endif
#if MULTIUV >= 3
layout(location = 7) in vec2 TexCoord3;
#endif

out vec3 VSWorldPos;
out vec4 VSColor;
out vec3 VSNormal;
out vec2 VSTexCoord;
#if MULTIUV >= 1
out vec2 VSTexCoord1;
#endif
#if MULTIUV >= 2
out vec2 VSTexCoord2;
#endif
#if MULTIUV >= 3
out vec2 VSTexCoord3;
#endif

vec2 TransformUV(vec2 uv, vec4 transform, vec2 translate)
{
	mat2 tm = mat2(transform.x, transform.y, transform.z, transform.w);
	return tm * uv + translate;
}

void main(void)
{
	gl_Position = WorldViewProj * vec4(Pos,1);
	VSWorldPos = Pos;
	VSColor = BaseColor;
	if(EnableVertexColor)
		VSColor *= VertCol;
	VSNormal = Normal;
	VSTexCoord = TransformUV(TexCoord, MapTransform, MapTranslate);
#if MULTIUV >= 1
	VSTexCoord1 = TransformUV(TexCoord1, MapTransform, MapTranslate);
#endif
#if MULTIUV >= 2
	VSTexCoord2 = TransformUV(TexCoord2, MapTransform, MapTranslate);
#endif
#if MULTIUV >= 3
	VSTexCoord3 = TransformUV(TexCoord3, MapTransform, MapTranslate);
#endif
}

