Texture2D ColorMap : register( t0 );
Texture2D AlphaMap : register( t1 );
SamplerState ColorMapSampler : register( s0 );
SamplerState AlphaMapSampler : register( s1 );

#include "world.inc"
#include "material.inc"
#include "texture.inc"

struct VS_INPUT
{
	float4 Pos : POSITION;
	float4 Col : COLOR0;
	float2 TexCoord : TEXCOORD0;
};

struct PS_INPUT
{
	float4 Pos : SV_POSITION;
	float4 Col : COLOR0;
	float2 TexCoord : TEXCOORD0;
	float4 WorldPos : TEXCOORD1;
};

PS_INPUT VS(const VS_INPUT In)
{
	PS_INPUT Out;
	Out.Pos = mul(In.Pos, WorldViewProj);
	Out.Col = In.Col;
	Out.TexCoord = In.TexCoord;
	Out.WorldPos = In.Pos;
	return Out;
}

float4 PS(PS_INPUT In) : SV_Target
{
	if(IsArbClipped(In.WorldPos.xyz))
		discard;
	float4 tex_col = LINEARtoSRGB(ColorMap.Sample(ColorMapSampler, In.TexCoord), HasTextureMap == 2);
	float4 alpha_col = AlphaMap.Sample(AlphaMapSampler, In.TexCoord);

	float4 col = tex_col * In.Col;
	col.a = tex_col.a * alpha_col.a * In.Col.a;
	clip(col.a - 1.0f/255.0f);
	return saturate(col);
}

