void StoreOIT(PS_INPUT In, float4 col)
{
#if OIT
    // Retrieve current pixel count and increase counter
    uint counter = OITLinkBuffer.IncrementCounter();
	if(counter >= (uint)OIT_AVERAGE_FRAGMENTS * Resolution.x * Resolution.y) return;

    // Exchange indices in StartOffsetTexture corresponding to pixel location 
    int2 tile_pos = floor(In.Pos.xy);// - TileRect.xy);
    uint new_offset = 4 * (tile_pos.x + Resolution.x * tile_pos.y);
    uint prev_offset = 0;
    OITStartOffsetBuffer.InterlockedExchange(new_offset, counter, prev_offset);
    
    // Append an element at the end of the Fragment and Link Buffer
    OITLinkBufferElement elem;
    elem.Color = PackFloat4IntoUint(col);
#if MSAA
    elem.DepthAndCoverage = PackDepthAndCoverageIntoUint(In.Pos.z, In.Coverage);
#else
    elem.DepthAndCoverage = PackDepthIntoUint(In.Pos.z);
#endif
    elem.Next = prev_offset;
    OITLinkBuffer[counter] = elem;
#endif
}

