#version 330

layout( lines_adjacency ) in;
layout( line_strip, max_vertices = 8) out;

uniform mat4 ProjMtx;
uniform float ClipFront;
uniform float ClipBack;
uniform int ResolutionX;
uniform int ResolutionY;
//uniform float LineWidth;
uniform float BackLineAlpha;

in vec3 VSViewPos[];
in vec3 VSWorldPos[];
in vec4 VSColor[];
in uint VSNumVert[];

out vec4 GSColor;
out vec3 GSWorldPos;

void main(void)
{
	vec2 sv0 = gl_in[0].gl_Position.xy / gl_in[0].gl_Position.w;
	vec2 sv1 = gl_in[1].gl_Position.xy / gl_in[1].gl_Position.w;
	vec2 sv2 = gl_in[2].gl_Position.xy / gl_in[2].gl_Position.w;
	vec2 sv3 = gl_in[3].gl_Position.xy / gl_in[3].gl_Position.w;
	uint numvert = VSNumVert[0] & 0x7u;
	float inprod1, inprod2;
	if(numvert >= 3u){
		inprod1 = (sv1.x-sv0.x) * (sv2.y-sv1.y)
	            - (sv1.y-sv0.y) * (sv2.x-sv1.x);
	}else{
		inprod1 = 1.0;
	}
	if(numvert >= 4u){
		inprod2 = (sv2.x-sv0.x) * (sv3.y-sv2.y)
	            - (sv2.y-sv0.y) * (sv3.x-sv2.x);
	}else{
		inprod2 = -1.0;
	}
	
	float a = (inprod1 > 0 || inprod2 > 0) ? 1.0 : BackLineAlpha * BackLineAlpha;
	if(a > 0.0){
		for(int i=0; i<4; i++){
			if((VSNumVert[i] & 0x80u) != 0u)
				continue;
			int i2 = (i+1)%4;
			int e2 = ((VSNumVert[i] & 0x20u) != 0u) ? i : i2;
			if(VSColor[i].a > 0.0 || VSColor[e2].a > 0.0){
				GSColor = VSColor[i];
				GSColor.a *= a;
				GSWorldPos = VSWorldPos[i];
				gl_Position = gl_in[i].gl_Position;
				EmitVertex();

				GSColor = VSColor[e2];
				GSColor.a *= a;
				GSWorldPos = VSWorldPos[i2];
				gl_Position = gl_in[i2].gl_Position;
				EmitVertex();
				EndPrimitive();
			}
		}
	}
}

