#version 330

uniform mat4 WorldViewProj;
uniform mat4 WorldView;

layout(location = 0) in vec3 Pos;
layout(location = 3) in vec4 VertCol;
layout(location = 5) in uint NumVert;

out vec3 VSViewPos;
out vec3 VSWorldPos;
out vec4 VSColor;
out uint VSNumVert;

void main(void)
{
	gl_Position = WorldViewProj * vec4(Pos,1);
	VSViewPos = vec3(WorldView * vec4(Pos,1));
	VSWorldPos = Pos;
	VSColor = VertCol;
	VSNumVert = NumVert;
}

