﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.0"/>
<xsl:variable name="lang" select="ja"/>

<!-- root -->
<xsl:template match="/">
 <html>
  <head>
   <title><xsl:value-of select="doc/class" /></title>
   <link rel="stylesheet" type="text/css" href="default.css"/>
  </head>
  <body>
   <h2><xsl:value-of select="doc/class" /> class</h2>
   <p><xsl:copy-of select="doc/message[@lang='ja']/node()" /></p>
   <xsl:apply-templates select="doc/superclasses" />
   <div>
    <xsl:apply-templates select="doc/properties" />
    <xsl:apply-templates select="doc/methods" />
   </div>
  </body>
 </html>
</xsl:template>

<!-- superclasses -->
<xsl:template match="doc/superclasses">
 <a name="__superclass" />
 <p>継承クラス: 
  <xsl:for-each select="superclass">
   <xsl:variable name="superclass"><xsl:value-of select="." /></xsl:variable>
   <xsl:if test="position() &gt; 1"> - </xsl:if>
   <a href="{$superclass}.html"><xsl:value-of select="." /></a>
  </xsl:for-each>
 </p>
</xsl:template>

<!-- property -->
<xsl:template match="doc/properties">
 <a name="__property" />
 <h3>Property</h3>
 <table class="property" border="1" cellspacing="0" cellpadding="1" rules="rows">
  <tbody>
   <tr bgcolor="#e0e0e0">
    <th valign="top">get</th>
    <th valign="top">set</th>
    <th valign="top" align="left">Type</th>
    <th valign="top" align="left">Name</th>
    <th valign="top" align="left">Description</th>
   </tr>
   <xsl:for-each select="property">
    <xsl:variable name="propname"><xsl:value-of select="name"/></xsl:variable>
    <xsl:variable name="bgcol">
     <xsl:if test="position() mod 2 = 0">#edf4f8</xsl:if>
     <xsl:if test="position() mod 2 = 1">#fffff8</xsl:if>
    </xsl:variable>
    <tr bgcolor="{$bgcol}">
     <td valign="top" align="center"><a name='{$propname}' /><xsl:choose><xsl:when test="get[.&gt; 0]">o</xsl:when><xsl:otherwise>x</xsl:otherwise></xsl:choose></td>
     <td valign="top" align="center"><xsl:choose><xsl:when test="set[.&gt; 0]">o</xsl:when><xsl:otherwise>x</xsl:otherwise></xsl:choose></td>
     <td valign="top"><xsl:apply-templates select="type" /></td>
     <td valign="top"><xsl:value-of select="name" /></td>
     <td valign="top">
       <xsl:value-of select="message[@lang='ja']" />
       <xsl:if test="values != ''">
        <table border="0">
         <tbody>
         <xsl:for-each select="values/value">
          <tr>
           <td>[<xsl:value-of select="@value" />] </td>
           <td><xsl:copy-of select="message[@lang='ja']/node()" /></td>
          </tr>
         </xsl:for-each>
        </tbody>
       </table>
      </xsl:if>
     </td>
    </tr>
   </xsl:for-each>
  </tbody>
 </table>
</xsl:template>

<!-- method -->
<xsl:template match="doc/methods">
 <h3>Method</h3>
 <!-- link list -->
 <table class="property" border="1" cellspacing="0" cellpadding="1" rules="rows">
  <tbody>
   <tr bgcolor="#e0e0e0">
    <th valign="top" align="left">Member</th>
    <th valign="top" align="left">Description</th>
   </tr>
   <xsl:for-each select="method">
    <xsl:variable name="bgcol">
     <xsl:if test="position() mod 2 = 0">#edf4f8</xsl:if>
     <xsl:if test="position() mod 2 = 1">#fffff8</xsl:if>
    </xsl:variable>
    <tr bgcolor="{$bgcol}">
     <td valign="top">
      <xsl:variable name="methodname"><xsl:value-of select="name"/></xsl:variable>
      <a href='#{$methodname}'><xsl:value-of select="name"/></a>
     </td>
     <td valign="top"><xsl:value-of select="message[@lang='ja']"/></td>
    </tr>
   </xsl:for-each>
  </tbody>
 </table>
 <p></p>
 <!-- description -->
 <xsl:for-each select="method">
  <table border="0" width="100%">
   <tbody>
    <!-- method name -->
    <tr>
     <td bgcolor="#cccccc">
      <xsl:variable name="methodname"><xsl:value-of select="name"/></xsl:variable>
      <a name='{$methodname}' />
      <b><xsl:value-of select="name"/></b>
      <xsl:for-each select="args/arg">
       <xsl:if test="position() = 1">(</xsl:if>
       <xsl:if test="@option='1' and (position()=1 or preceding-sibling::*[position()=1]/@option!='1')">[</xsl:if>
       <xsl:if test="position() &gt; 1">, </xsl:if>
       <xsl:value-of select="name"/>
       <xsl:if test="@option='1' and (position()=last() or following-sibling::*[position()=1]/@option!='1')">]</xsl:if>
       <xsl:if test="position() = last()">)</xsl:if>
      </xsl:for-each>
     </td>
    </tr>
    <tr>
     <td><p><xsl:value-of select="message[@lang='ja']"/></p></td>
    </tr>
    <!-- args value -->
    <xsl:if test="args != ''">
     <tr>
      <td>
       <dl>
        <dt><b>引数：</b></dt>
        <dd>
         <table border="0">
          <tbody>
           <xsl:for-each select="args/arg">
            <tr>
             <td valign="top"><xsl:apply-templates select="type"/></td>
             <td valign="top"><em><xsl:value-of select="name"/></em></td>
             <td valign="top">-</td>
             <td valign="top">
              <xsl:copy-of select="message[@lang='ja']/node()"/>
              <xsl:if test="values != ''">
               <br />
               <xsl:for-each select="values/value">
                [<xsl:value-of select="@value" />] <xsl:copy-of select="message[@lang='ja']/node()" /><br />
               </xsl:for-each>
              </xsl:if>
             </td>
            </tr>
           </xsl:for-each>
          </tbody>
         </table>
        </dd>
       </dl>
      </td>
     </tr>
    </xsl:if>
    <!-- return value -->
    <xsl:for-each select="return">
     <tr>
      <td>
       <dl>
        <dt><b>戻り値：</b></dt>
        <dd>
         <table border="0">
          <tbody>
           <tr>
            <td valign="top"><xsl:apply-templates select="type"/></td>
            <td valign="top">-</td>
            <td valign="top">
             <xsl:copy-of select="message[@lang='ja']/node()"/>
             <xsl:if test="values != ''">
              <br />
              <xsl:for-each select="values/value">
               [<xsl:value-of select="@value" />] <xsl:copy-of select="message[@lang='ja']/node()" /><br />
              </xsl:for-each>
             </xsl:if>
            </td>
           </tr>
          </tbody>
         </table>
        </dd>
       </dl>
      </td>
     </tr>
    </xsl:for-each>
    <!-- attention -->
    <xsl:if test="attention!=''">
     <tr>
      <td>
       <dl>
        <dt><b>注意点：</b></dt>
        <dd><xsl:copy-of select="attention[@lang='ja']/node()" /></dd>
       </dl>
      </td>
     </tr>
    </xsl:if>
    <!-- example -->
    <xsl:if test="example!=''">
     <tr>
      <td>
       <dl>
        <dt><b>例：</b></dt>
        <dd><xsl:copy-of select="example[@lang='ja']/node()" /></dd>
       </dl>
      </td>
     </tr>
    </xsl:if>
   </tbody>
  </table>
  <p></p>
 </xsl:for-each>
</xsl:template>

<!-- type -->
<xsl:template match="type">
 <xsl:if test="@template='list'">list&lt;</xsl:if>
 <xsl:choose>
  <xsl:when test=".='MQDocument'"><a href="MQDocument.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQScene'"><a href="MQScene.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQObject'"><a href="MQObject.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQVertex'"><a href="MQVertex.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQFace'"><a href="MQFace.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQMaterial'"><a href="MQMaterial.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQShaderNode'"><a href="MQShaderNode.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQEnvMap'"><a href="MQEnvMap.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQPoint'"><a href="MQPoint.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQCoordinate'"><a href="MQCoordinate.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQAngle'"><a href="MQAngle.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQMatrix'"><a href="MQMatrix.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQColor'"><a href="MQColor.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:when test=".='MQSetting'"><a href="MQSetting.html"><xsl:value-of select="."/></a></xsl:when>
  <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
 </xsl:choose>
 <xsl:if test="@template='list'">&gt;</xsl:if>
</xsl:template>

</xsl:stylesheet>
