#include "world.inc"
#include "material.inc"
#if OIT
#include "oit.inc"
#endif

struct VS_INPUT
{
	float4 Pos : POSITION;
	float4 Col : COLOR0;
};

struct VS_OUTPUT
{
	float4 Pos : SV_POSITION;
	float4 WorldPos : TEXCOORD0;
	float4 Col : COLOR0;
};

struct PS_INPUT
{
	float4 Pos : SV_POSITION;
	float4 WorldPos : TEXCOORD0;
	float4 Col : COLOR0;
#if MSAA
    uint Coverage : SV_COVERAGE;
#endif
};

#include "oit_store.inc"


VS_OUTPUT VS(const VS_INPUT In)
{
	VS_OUTPUT Out;
	Out.Pos = mul(In.Pos, WorldViewProj);
	Out.WorldPos = In.Pos;
	Out.Col = In.Col;
	return Out;
}

#if OIT
[earlydepthstencil]
#endif
float4 PS(PS_INPUT In) : SV_Target
{
	if(IsArbClipped(In.WorldPos.xyz))
		discard;
	float4 output = In.Col;

#if OIT
    StoreOIT(In, output);
    output = float4(0,0,0,0);	// This does not affect anything because RenderTargetWriteMask is 0.
#endif

	return output;
}

