#version 330

uniform mat4 WorldViewProj;
uniform mat4 WorldView;
uniform vec4 BaseColor;
uniform bool EnableVertexColor;

layout(location = 0) in vec3 Pos;
layout(location = 3) in vec4 VertCol;

out vec3 VSViewPos;
out vec3 VSWorldPos;
out vec4 VSColor;

void main(void)
{
	gl_Position = WorldViewProj * vec4(Pos,1);
	VSViewPos = vec3(WorldView * vec4(Pos,1));
	VSWorldPos = Pos;
	VSColor = BaseColor;
	if(EnableVertexColor)
		VSColor *= VertCol;
}

