#version 330

layout( lines_adjacency ) in;
layout( triangle_strip, max_vertices = 16) out;

uniform mat4 ProjMtx;
uniform float ClipFront;
uniform float ClipBack;
uniform int ResolutionX;
uniform int ResolutionY;
uniform float PointSize;
uniform float BackLineAlpha;

in vec3 VSViewPos[];
in vec3 VSWorldPos[];
in vec4 VSColor[];
in uint VSNumVert[];

out vec4 GSColor;
out vec3 GSWorldPos;

void main(void)
{
	vec2 sv0 = gl_in[0].gl_Position.xy / gl_in[0].gl_Position.w;
	vec2 sv1 = gl_in[1].gl_Position.xy / gl_in[1].gl_Position.w;
	vec2 sv2 = gl_in[2].gl_Position.xy / gl_in[2].gl_Position.w;
	vec2 sv3 = gl_in[3].gl_Position.xy / gl_in[3].gl_Position.w;
	float inprod1, inprod2;
	if(VSNumVert[0] >= 3u){
		inprod1 = (sv1.x-sv0.x) * (sv2.y-sv1.y)
	            - (sv1.y-sv0.y) * (sv2.x-sv1.x);
	}else{
		inprod1 = 1.0;
	}
	if(VSNumVert[0] >= 4u){
		inprod2 = (sv2.x-sv0.x) * (sv3.y-sv2.y)
	            - (sv2.y-sv0.y) * (sv3.x-sv2.x);
	}else{
		inprod2 = -1.0;
	}
	
	float a = (inprod1 > 0 || inprod2 > 0) ? 1.0 : BackLineAlpha;
	if(a > 0.0){
		for(uint i=0u; i<VSNumVert[0] && i<4u; i++){
			if(VSColor[i].a > 0.0){
				float dx = gl_in[i].gl_Position.w * 2.0 * PointSize / ResolutionX;
				float dy = gl_in[i].gl_Position.w * 2.0 * PointSize / ResolutionY;

				// Emit two new triangles
				GSWorldPos = VSWorldPos[i];
				GSColor = VSColor[i];
				gl_Position = gl_in[i].gl_Position;
				gl_Position.x -= dx;
				gl_Position.y += dy;
				EmitVertex();

				GSWorldPos = VSWorldPos[i];
				GSColor = VSColor[i];
				gl_Position = gl_in[i].gl_Position;
				gl_Position.x += dx;
				gl_Position.y += dy;
				EmitVertex();

				GSWorldPos = VSWorldPos[i];
				GSColor = VSColor[i];
				gl_Position = gl_in[i].gl_Position;
				gl_Position.x -= dx;
				gl_Position.y -= dy;
				EmitVertex();

				GSWorldPos = VSWorldPos[i];
				GSColor = VSColor[i];
				gl_Position = gl_in[i].gl_Position;
				gl_Position.x += dx;
				gl_Position.y -= dy;
				EmitVertex();

				EndPrimitive();
			}
		}
	}
}

