#version 330

layout( lines ) in;
layout( triangle_strip, max_vertices = 4) out;

uniform mat4 ProjMtx;
uniform float ClipFront;
uniform float ClipBack;
uniform int ResolutionX;
uniform int ResolutionY;
uniform float LineWidth;

in vec3 VSViewPos[];
in vec3 VSWorldPos[];
in vec4 VSColor[];

out vec4 GSColor;
out vec3 GSWorldPos;

float normz(float z) { return z*0.5 + 0.5; }

void main(void)
{
	vec4 pos1 = gl_in[0].gl_Position;
	vec4 pos2 = gl_in[1].gl_Position;
	if(pos1.z >= -pos1.w && pos2.z >= -pos2.w){
		// normal display
	}else if(pos1.z >= -pos1.w && pos2.z < -pos2.w){
		float t = (ClipFront - VSViewPos[0].z) / (VSViewPos[1].z - VSViewPos[0].z);
		vec3 viewpos = (1-t)*VSViewPos[0] + t*VSViewPos[1];
		pos2 = ProjMtx * vec4(viewpos,1);
	}else if(pos1.z < -pos1.w && pos2.z >= -pos2.w){
		float t = (ClipFront-VSViewPos[1].z) / (VSViewPos[0].z-VSViewPos[1].z);
		vec3 viewpos = (1-t)*VSViewPos[1] + t*VSViewPos[0];
		pos1 = ProjMtx * vec4(viewpos,1);
	}else{
		return;
	}

	vec2 vec = normalize(pos1.yx / pos1.w - pos2.yx / pos2.w);
	vec.x *= -LineWidth / ResolutionX;
	vec.y *= LineWidth / ResolutionY;

	GSColor = VSColor[0];
	GSWorldPos = VSWorldPos[0];
	gl_Position = pos1;
	gl_Position.xy += pos1.w * vec.xy;
	EmitVertex();

	GSColor = VSColor[0];
	GSWorldPos = VSWorldPos[0];
	gl_Position = pos1;
	gl_Position.xy -= pos1.w * vec.xy;
	EmitVertex();

	GSColor = VSColor[1];
	GSWorldPos = VSWorldPos[1];
	gl_Position = pos2;
	gl_Position.xy += pos2.w * vec.xy;
	EmitVertex();

	GSColor = VSColor[1];
	GSWorldPos = VSWorldPos[1];
	gl_Position = pos2;
	gl_Position.xy -= pos2.w * vec.xy;
	EmitVertex();

	EndPrimitive();
}

